import java.rmi.Naming;

/**
 * Classe che manda in esecuzione il servizio di generatore di
 * ID univoci
 * 
 * @author Letizia Cheng Cheng
 * @version 1.0
 */
public class IDUniqueApplication {
	public static void main(String args[]) {
		//Istanziazione degli stream di output
		ShowMessagePrompt show=new ShowMessagePrompt();
		int portNum,valBase=0;
		String host;
		if((args.length!=2)&&(args.length!=3)){
			show.println("Usage: java IDUniqueApplication <host> <portNum>");
			show.println("OR");
			show.println("Usage: java IDUniqueApplication <host> <portNum> [numBaseID]");
			System.exit(0);
		}
		try{
			host=args[0];
			portNum=Integer.parseInt(args[1]);
			if(args.length==3)
				valBase=Integer.parseInt(args[2]);
			String service="IDUnique";
			String rURL="rmi://"+host+":"+ portNum +"/"+service;
			
			
			IDUniqueImpl server_ref = new IDUniqueImpl(valBase);
			Naming.rebind(rURL, server_ref);
			show.println("IDUnique Server ready.");
			
		}
		catch(Exception e){
			show.println("Exception in IDUnique Server: "+e);
			System.exit(1);
		}
		
	}

}
